<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p_v124'
 *
 * @package    h5plib_v124
 * @copyright  2019 Andrew Nicols <andrew@nicols.co.uk>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['editor:a11ytitleshowlabel'] = 'Show label for AT';
$string['editor:a11ytitlehidelabel'] = 'Hide label for AT';
$string['editor:atoz'] = 'A to Z';
$string['editor:add'] = 'Add';
$string['editor:addauthor'] = 'Save author';
$string['editor:addentity'] = 'Add :entity';
$string['editor:addfile'] = 'Add file';
$string['editor:addnewchange'] = 'Add new change';
$string['editor:addtitle'] = 'Add title';
$string['editor:addvideodescription'] = 'H5P supports all external video sources formatted as mp4, webm or ogv, like Vimeo Pro, and has support for YouTube and Panopto links.';
$string['editor:avtablistlabel'] = 'Insert using';
$string['editor:belowmin'] = 'The :property value is below the minimum of :min.';
$string['editor:cancel'] = 'Cancel';
$string['editor:cancellabel'] = 'Cancel';
$string['editor:changefile'] = 'Change file';
$string['editor:changelanguage'] = 'Change language to :language?';
$string['editor:changelibrary'] = 'Change content type?';
$string['editor:changelogdescription'] = 'Some licences require that changes made to the original work, or derivatives are logged and displayed. You may log your changes here for licensing reasons or just to allow yourself and others to keep track of the changes made to this content.';
$string['editor:close'] = 'Close';
$string['editor:commonfields'] = 'Text overrides and translations';
$string['editor:commonfieldsdescription'] = 'Here you can edit settings or translate texts used in this content.';
$string['editor:confirmchangelibrary'] = 'By doing this you will lose all work done with the current content type. Are you sure you wish to change content type?';
$string['editor:confirmdeletechangelog'] = 'Are you sure you would like to delete this change log entry?';
$string['editor:confirmimageremoval'] = 'This will remove your image. Are you sure you wish to proceed?';
$string['editor:confirmpastebuttontext'] = 'Replace content';
$string['editor:confirmpastecontent'] = 'By doing this you will replace the current content with the content from your clipboard. The current content will be lost. Are you sure you wish to continue?';
$string['editor:confirmremoval'] = 'Are you sure you wish to remove this :type?';
$string['editor:confirmremoveauthor'] = 'Are you sure you would like to remove this author?';
$string['editor:contenttypebackbuttonlabel'] = 'Back';
$string['editor:contenttypecacheoutdated'] = 'Content type list outdated';
$string['editor:contenttypecacheoutdateddesc'] = 'Your site is having difficulties connecting to H5P.org to check for content type updates. You may not be able to update or install new content types.';
$string['editor:contenttypedemobuttonlabel'] = 'Content demo';
$string['editor:contenttypedetailbuttonlabel'] = 'Details';
$string['editor:contenttypegetbuttonlabel'] = 'Get';
$string['editor:contenttypeiconalttext'] = 'Icon';
$string['editor:contenttypeinstallbuttonlabel'] = 'Install';
$string['editor:contenttypeinstallerror'] = ':contentType could not be installed. Contact your administrator.';
$string['editor:contenttypeinstallsuccess'] = ':contentType successfully installed!';
$string['editor:contenttypeinstallingbuttonlabel'] = 'Installing';
$string['editor:contenttypelicensepaneltitle'] = 'Licence';
$string['editor:contenttypenotinstalled'] = 'Content type not installed';
$string['editor:contenttypenotinstalleddesc'] = 'You do not have permission to install content types.';
$string['editor:contenttypeowner'] = 'By :owner';
$string['editor:contenttyperestricted'] = 'Restricted content type';
$string['editor:contenttyperestricteddesc'] = 'The use of this content type has been restricted by an administrator.';
$string['editor:contenttypesearchfieldplaceholder'] = 'Search for content types';
$string['editor:contenttypesectionall'] = 'All content types';
$string['editor:contenttypeunsupportedapiversioncontent'] = 'Contact your system administrator to provide you with the necessary updates';
$string['editor:contenttypeunsupportedapiversiontitle'] = 'This content type requires a newer core version';
$string['editor:contenttypeupdateavailable'] = 'Update available';
$string['editor:contenttypeupdatebuttonlabel'] = 'Update';
$string['editor:contenttypeupdatesuccess'] = ':contentType successfully updated!';
$string['editor:contenttypeupdatingbuttonlabel'] = 'Updating';
$string['editor:contenttypeusebuttonlabel'] = 'Use';
$string['editor:contributetranslations'] = 'If you want to complete the translation for :language, see <a href=":url" target="_new">contributing translations to H5P</a>.';
$string['editor:copiedbutton'] = 'Copied';
$string['editor:copiedtoclipboard'] = 'Content is copied to the clipboard';
$string['editor:copybutton'] = 'Copy';
$string['editor:copytoclipboard'] = 'Copy H5P content to the clipboard';
$string['editor:createcontenttablabel'] = 'Create content';
$string['editor:currentmenuselected'] = 'current selection';
$string['editor:editcopyright'] = 'Edit copyright';
$string['editor:editimage'] = 'Edit image';
$string['editor:editmode'] = 'Editing mode';
$string['editor:enteraudiotitle'] = 'Paste link or other audio source URL';
$string['editor:enteraudiourl'] = 'Enter audio source URL';
$string['editor:enterfullscreenbuttonlabel'] = 'Enter fullscreen';
$string['editor:entervideotitle'] = 'Paste YouTube link or other video source URL';
$string['editor:entervideourl'] = 'Enter video URL';
$string['editor:errorcalculatingmaxscore'] = 'Could not calculate the max score for this content. The max score is assumed to be 0. Contact your administrator if this isn’t correct.';
$string['editor:errorcommunicatinghubcontent'] = 'An error occured. Please try again.';
$string['editor:errorcommunicatinghubtitle'] = 'Not able to communicate with hub.';
$string['editor:errorheader'] = 'An error occured';
$string['editor:errornotsupported'] = 'Parameters contain %used which is not supported.';
$string['editor:errorparamsbroken'] = 'Parameters are broken.';
$string['editor:errortoohighversion'] = 'Parameters contain %used while only %supported or earlier are supported.';
$string['editor:example'] = 'Example';
$string['editor:exceedsmax'] = 'The :property value exceeds the maximum of :max.';
$string['editor:exitfullscreenbuttonlabel'] = 'Exit fullscreen';
$string['editor:expandcollapse'] = 'Expand/Collapse';
$string['editor:filetolarge'] = 'The file you are trying to upload might be too large.';
$string['editor:fillinthefieldsbelow'] = 'Fill in the fields below';
$string['editor:gethelp'] = 'Get help';
$string['editor:h5pfileuploadservererrorcontent'] = 'An unexpected error occurred. Check your server error log for more details.';
$string['editor:h5pfileuploadservererrortitle'] = 'The H5P file could not be uploaded';
$string['editor:h5pfilevalidationfailedcontent'] = 'Make sure the uploaded H5P contains valid H5P content. H5P files containing only libraries should be uploaded through the H5P libraries page.';
$string['editor:h5pfilevalidationfailedtitle'] = 'Could not validate H5P file.';
$string['editor:h5pfilewrongextensioncontent'] = 'Only files with the .h5p extension are allowed.';
$string['editor:h5pfilewrongextensiontitle'] = 'The selected file could not be uploaded';
$string['editor:height'] = 'height';
$string['editor:hide'] = 'Hide';
$string['editor:hideimportantinstructions'] = 'Hide important instructions';
$string['editor:hubpanellabel'] = 'Select content type';
$string['editor:illegaldecimalnumber'] = ':property can only contain numbers with max :decimals decimals.';
$string['editor:imagelightboxprogress'] = ':num of :total';
$string['editor:imagelightboxtitle'] = 'Images';
$string['editor:importantinstructions'] = 'Important instructions';
$string['editor:insert'] = 'Insert';
$string['editor:invalidformat'] = 'Field value contains an invalid format or characters that are forbidden.';
$string['editor:language'] = 'Language';
$string['editor:librarymissing'] = 'Missing required library %lib.';
$string['editor:licensecandistribute'] = 'Can distribute';
$string['editor:licensecanholdliable'] = 'Can hold liable';
$string['editor:licensecanmodify'] = 'Can modify';
$string['editor:licensecansublicense'] = 'Can sub-licence';
$string['editor:licensecanusecommercially'] = 'Can use commercially';
$string['editor:licensecannotholdliable'] = 'Cannot hold liable';
$string['editor:licensedescription'] = 'Some of the features of this licence are indicated below. Click the info icon above to read the original licence text.';
$string['editor:licensefetchdetailsfailed'] = 'Failed fetching licence details';
$string['editor:licensemodalsubtitle'] = 'Select a licence to view information about proper usage';
$string['editor:licensemodaltitle'] = 'Licence details';
$string['editor:licensemustincludecopyright'] = 'Must include copyright';
$string['editor:licensemustincludelicense'] = 'Must include licence';
$string['editor:licenseunspecified'] = 'Unspecified';
$string['editor:listbelowmin'] = 'The list needs at least :min items for the content to function properly.';
$string['editor:listexceedsmax'] = 'The list exceeds the maximum of :max items.';
$string['editor:listlabel'] = 'List';
$string['editor:loading'] = 'Loading, please wait...';
$string['editor:loadingimageeditor'] = 'Loading image editor, please wait...';
$string['editor:logthischange'] = 'Log this change';
$string['editor:loggedchanges'] = 'Logged changes';
$string['editor:maxscoresemanticsmissing'] = 'Could not find the expected semantics in the content.';
$string['editor:metadata'] = 'Metadata';
$string['editor:metadatasharingandlicensinginfo'] = 'Metadata (sharing and licencing info)';
$string['editor:missingproperty'] = 'Field :index is missing its :property property.';
$string['editor:missingtranslation'] = '[Missing translation :key]';
$string['editor:newchangehasbeenlogged'] = 'New change has been logged';
$string['editor:newestfirst'] = 'Newest first';
$string['editor:nextimage'] = 'Next image';
$string['editor:nochangeshavebeenlogged'] = 'No changes have been logged';
$string['editor:nocontenttypesavailable'] = 'No content types are available';
$string['editor:nocontenttypesavailabledesc'] = 'Your site is having difficulties connecting to H5P.org and listing the available content types.';
$string['editor:nofollow'] = 'Cannot follow field ":path".';
$string['editor:nolanguagessupported'] = 'No languages supported';
$string['editor:noresultsfound'] = 'No results found';
$string['editor:noresultsfounddesc'] = 'There is no content type that matches your search criteria.';
$string['editor:nosemantics'] = 'Error, could not load the content type form.';
$string['editor:notalltextschanged'] = 'Not all texts were changed, as there is only partial coverage for :language.';
$string['editor:notimagefield'] = '":path" is not an image.';
$string['editor:notimageordimensionsfield'] = '":path" is not an image or dimensions field.';
$string['editor:numresults'] = ':num results';
$string['editor:numberfield'] = 'number field';
$string['editor:ok'] = 'OK';
$string['editor:onlynumbers'] = 'The :property value can only contain numbers.';
$string['editor:or'] = 'or';
$string['editor:orderitemdown'] = 'Order item down';
$string['editor:orderitemup'] = 'Order item up';
$string['editor:outofstep'] = 'The :property value can only be changed in steps of :step.';
$string['editor:pasteandreplacebutton'] = 'Paste and replace';
$string['editor:pasteandreplacefromclipboard'] = 'Replace existing content with H5P content from the clipboard';
$string['editor:pastebutton'] = 'Paste';
$string['editor:pastecontent'] = 'Replace content';
$string['editor:pastecontentnotsupported'] = 'The content in the H5P clipboard is not supported in this context';
$string['editor:pastecontentrestricted'] = 'The content in the clipboard has been restricted on this site';
$string['editor:pasteerror'] = 'Cannot paste from clipboard';
$string['editor:pastefromclipboard'] = 'Paste H5P content from the clipboard';
$string['editor:pastenocontent'] = 'No H5P content on the clipboard';
$string['editor:pastetoonew'] = 'The content in the H5P clipboard is of a higher version (:clip) than what is supported in this context (:local). If possible, try to have this content upgraded first, then try pasting the content here again.';
$string['editor:pastetooold'] = 'The content in the H5P clipboard is of a lower version (:clip) than what is supported in this context (:local). If possible, try to have the content you want to paste upgraded, then copy it again and try pasting it here.';
$string['editor:popularfirst'] = 'Popular first';
$string['editor:previousimage'] = 'Previous image';
$string['editor:proceedbuttonlabel'] = 'Proceed to save';
$string['editor:readless'] = 'Read less';
$string['editor:readmore'] = 'Read more';
$string['editor:recentlyusedfirst'] = 'Recently used first';
$string['editor:reloadbuttonlabel'] = 'Reload';
$string['editor:removefile'] = 'Remove file';
$string['editor:removeimage'] = 'Remove image';
$string['editor:removeitem'] = 'Remove item';
$string['editor:requiredproperty'] = 'The :property is required and must have a value.';
$string['editor:resettooriginallabel'] = 'Reset to original';
$string['editor:savelabel'] = 'Save';
$string['editor:savemetadata'] = 'Save metadata';
$string['editor:screenshots'] = 'Screenshots';
$string['editor:scriptmissing'] = 'Could not load upgrades script for %lib.';
$string['editor:searchresults'] = 'Search results';
$string['editor:selectfiletoupload'] = 'Select file to upload';
$string['editor:selectlibrary'] = 'Select the library you wish to use for your content.';
$string['editor:semanticserror'] = 'Semantics error: :error';
$string['editor:show'] = 'Show';
$string['editor:showimportantinstructions'] = 'Show instructions';
$string['editor:tabtitlebasicfileupload'] = 'File upload';
$string['editor:tabtitleinputlinkurl'] = 'Link/URL';
$string['editor:textfield'] = 'text field';
$string['editor:thecontenttype'] = 'the content type';
$string['editor:thiswillpotentially'] = 'This will potentially reset all the text and translations. You can\'t undo this. The content itself will not be changed. Do you want to proceed?';
$string['editor:title'] = 'Title';
$string['editor:toolong'] = 'Field value is too long; it should contain :max letters or less.';
$string['editor:tryagain'] = 'Try again';
$string['editor:tutorial'] = 'Tutorial';
$string['editor:unabletointerpreterror'] = 'Unable to interpret response.';
$string['editor:unabletointerpretsolution'] = 'Please check your error log.';
$string['editor:unknownfieldpath'] = 'Unable to find ":path".';
$string['editor:unknownfileuploaderror'] = 'Unknown file upload error';
$string['editor:unknownlibrary'] = 'Unfortunately, the selected content type \'%lib\' isn\'t installed on this system.';
$string['editor:untitled'] = 'Untitled :libraryTitle';
$string['editor:uploadaudiotitle'] = 'Upload audio file';
$string['editor:uploaderror'] = 'File upload error';
$string['editor:uploadfilebuttonchangelabel'] = 'Change file';
$string['editor:uploadfilebuttonlabel'] = 'Upload a file';
$string['editor:uploadinstructionscontent'] = 'You may start with examples from <a href="https://h5p.org/content-types-and-applications" target="blank">H5P.org</a>.';
$string['editor:uploadinstructionstitle'] = 'Upload an H5P file.';
$string['editor:uploadplaceholder'] = 'No file chosen';
$string['editor:uploadsuccess'] = ':title was successfully uploaded!';
$string['editor:uploadtablabel'] = 'Upload';
$string['editor:uploadvideotitle'] = 'Upload video file';
$string['editor:uploading'] = 'Uploading, please wait...';
$string['editor:uploadingthrobber'] = 'Now uploading...';
$string['editor:usedforsearchingreportsandcopyrightinformation'] = 'Used for searching, reports and copyright information';
$string['editor:videoquality'] = 'Video quality label';
$string['editor:videoqualitydefaultlabel'] = 'Quality :index';
$string['editor:videoqualitydescription'] = 'This label helps the user identify the current quality of the video. E.g. 1080p, 720p, HD or Mobile';
$string['editor:warningchangebrowsingtoseeresults'] = 'Click <em>All</em> to get the list of all the content types you can install.';
$string['editor:warningnocontenttypesinstalled'] = 'You don\'t have any content types installed.';
$string['editor:warningupdateavailablebody'] = 'Update to the latest version for an improved experience.';
$string['editor:warningupdateavailabletitle'] = 'A new version of :contentType is available.';
$string['editor:width'] = 'width';
$string['pluginname'] = 'H5P framework v1.24';
$string['pluginname_help'] = 'H5P framework version 1.24.';
$string['privacy:metadata'] = 'The H5P framework v1.24 does not store any personal data.';
